/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client;

import com.mojang.blaze3d.vertex.PoseStack;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import pregenerator.PregenConfig;
import pregenerator.base.api.Align;
import pregenerator.base.impl.RenderHelper;
import pregenerator.client.info.IProcessorInfo;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.networking.processing.ProcessorInfoRequest;

public class ProcessorRenderer {
    Map<ResourceKey<Level>, IProcessorInfo> byType = new Object2ObjectOpenHashMap();
    List<ResourceKey<Level>> infos = new ObjectArrayList();

    public void onInfoPacketReceived(byte[] data) {
        if (data.length <= 0) {
            this.byType.clear();
            this.infos.clear();
            return;
        }
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])data));
        ObjectOpenHashSet found = new ObjectOpenHashSet();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            ResourceKey type = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buffer.m_130281_());
            found.add(type);
            IProcessorInfo info = this.byType.get(type);
            if (info != null) {
                buffer.readByte();
                info.read(buffer);
                continue;
            }
            info = IProcessorInfo.create(buffer.readByte());
            info.read(buffer);
            this.byType.put((ResourceKey<Level>)type, info);
            this.infos.add((ResourceKey<Level>)type);
        }
        this.infos.retainAll((Collection<?>)found);
        this.byType.keySet().retainAll((Collection<?>)found);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onUIRenderer(RenderGameOverlayEvent.Post event) {
        if (!this.shouldRender()) {
            return;
        }
        int yLevel = 0;
        int m = this.infos.size();
        for (int i = 0; i < m; ++i) {
            IProcessorInfo info = this.byType.get(this.infos.get(i));
            yLevel += info != null ? info.getHeight() : 0;
        }
        RenderHelper helper = new RenderHelper();
        PoseStack stack = event.getMatrixStack();
        helper.init(stack);
        PregenConfig config = PregenConfig.INSTANCE;
        float zoom = ((Double)config.pregenZoom.get()).floatValue();
        float invZoom = 1.0f / zoom;
        yLevel = (int)((float)yLevel + (float)yLevel * zoom);
        stack.m_85836_();
        if (zoom != 1.0f) {
            stack.m_85841_(zoom, zoom, 1.0f);
        }
        Align vertical = (Align)((Object)config.pregenVAlign.get());
        Align horizontal = (Align)((Object)config.pregenHAlign.get());
        yLevel = (int)((float)this.calculateHeight(vertical, this.getScreenHeight(), yLevel) * invZoom);
        int screenX = (int)((float)this.getScreenWidth() * invZoom);
        int m2 = this.infos.size();
        for (int i = 0; i < m2; ++i) {
            IProcessorInfo info = this.byType.get(this.infos.get(i));
            if (info == null) continue;
            info.render(helper, this.calculateXOffset(horizontal, screenX, info), yLevel);
            yLevel += info.getHeight();
        }
        stack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void update() {
        NetworkManager.INSTANCE.sendToServer(new ProcessorInfoRequest());
    }

    public boolean shouldRender() {
        return (Boolean)PregenConfig.INSTANCE.pregenOverlay.get();
    }

    public void setVisible(boolean value) {
        PregenConfig config = PregenConfig.INSTANCE;
        config.pregenOverlay.set((Object)value);
        config.pregenOverlay.save();
    }

    @OnlyIn(value=Dist.CLIENT)
    private int getScreenHeight() {
        return Minecraft.m_91087_().m_91268_().m_85446_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private int getScreenWidth() {
        return Minecraft.m_91087_().m_91268_().m_85445_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private int calculateXOffset(Align align, int screenWidth, IProcessorInfo info) {
        switch (align) {
            case CENTER: {
                return screenWidth / 2 - info.getWidth() / 2;
            }
            case END: {
                return screenWidth - info.getWidth();
            }
        }
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    private int calculateHeight(Align align, int screenHeight, int yLevel) {
        if (align == Align.END) {
            return screenHeight - yLevel;
        }
        if (align == Align.CENTER) {
            return screenHeight / 2 - yLevel / 2;
        }
        return 1;
    }
}

